DROP TABLE IF EXISTS ibf_shoutbox_badwords;
DROP TABLE IF EXISTS ibf_shoutbox_colors;
DROP TABLE IF EXISTS ibf_shoutbox_settings;
DROP TABLE IF EXISTS ibf_shoutbox_stats;

CREATE TABLE ibf_shoutbox_badwords (
  id int(11) NOT NULL auto_increment,
  bword varchar(255) NOT NULL default '',
  switch varchar(255) default NULL,
  exact tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
);

CREATE TABLE ibf_shoutbox_colors (
  id int(11) NOT NULL auto_increment,
  color varchar(255) NOT NULL,
  PRIMARY KEY  (id)
);

CREATE TABLE ibf_shoutbox_settings (
  online tinyint(1) NOT NULL default '1',
  sbname varchar(255) NOT NULL default 'D-Shoutbox',
  postspp int(11) NOT NULL default '10',
  flood int(11) NOT NULL default '10',
  flood_seconds int(11) NOT NULL default '30',
  guestviewsb tinyint(1) NOT NULL default '1',
  guestposting tinyint(1) NOT NULL default '0',
  minimum_refresh int(11) default '30',
  refresh int(11) NOT NULL default '10',
  banner tinyint(1) default '0',
  bannerurl varchar(255) default NULL,
  autodelete tinyint(1) default '0',
  addays smallint(3) default '0',
  showava tinyint(1) NOT NULL default '1',
  showglobal tinyint(1) NOT NULL default '1',
  showou tinyint(1) NOT NULL default '1',
  showrules tinyint(1) NOT NULL default '1',
  showtods tinyint(1) NOT NULL default '1',
  todsnum int(11) default '10',
  showtops tinyint(1) NOT NULL default '1',
  topsnum int(11) default '10',
  smiliestable tinyint(1) NOT NULL default '1',
  iframe tinyint(1) NOT NULL default '1',
  iframeh mediumint(5) NOT NULL default '370',
  iframew mediumint(5) NOT NULL default '100',
  noavatar_name varchar(255) NOT NULL default '',
  avatar_dims varchar(255) NOT NULL default '80x80',
  allowsmilies tinyint(1) NOT NULL default '1',
  allowbbcodes tinyint(1) NOT NULL default '1',
  usestorep tinyint(1) default NULL,
  useshopp tinyint(1) default NULL,
  usesbcard tinyint(1) default NULL,
  chargeperpost int(11) default NULL,
  shoppoints int(11) default NULL,
  storepoints int(11) default NULL,
  website_extra text,
  error_msg_1 text NOT NULL,
  error_msg_2 text NOT NULL,
  error_msg_3 text NOT NULL,
  error_msg_4 text NOT NULL,
  error_msg_5 text NOT NULL,
  error_msg_6 text NOT NULL,
  error_msg_7 text NOT NULL,
  error_msg_8 text NOT NULL,
  error_msg_9 text NOT NULL,
  gsnum int(11) NOT NULL default '5',
  wordwrap int(11) NOT NULL default '0',
  gseffect int(2) NOT NULL default '0',
  skin_selection char(3) NOT NULL default 'new',
  sbdisplay char(1) NOT NULL default 'L',
  global_rlb tinyint(1) NOT NULL default '0'
);

CREATE TABLE ibf_shoutbox_stats (
  totalshouts int(11) NOT NULL default '0',
  shouts_alltime int(11) NOT NULL default '0'
);

INSERT INTO ibf_shoutbox_colors VALUES ('1', 'black');
INSERT INTO ibf_shoutbox_colors VALUES ('2', 'blue');
INSERT INTO ibf_shoutbox_colors VALUES ('3', 'red');
INSERT INTO ibf_shoutbox_colors VALUES ('4', 'green');
INSERT INTO ibf_shoutbox_colors VALUES ('5', 'yellow');
INSERT INTO ibf_shoutbox_stats VALUES ('1', '1');
INSERT INTO ibf_shoutbox_settings VALUES (1, 'D-Shoutbox', 10, 10, 30, 1, 0, 30, 10, 0, '', 0, 0, 1, 1, 1, 1, 1, 10, 1, 10, 1, 1, 370, 100, '', '80x80', 0, 0, 0, 0, 0, 0, 0, 0, '', 'Sorry, guests cant view the shoutbox&#33;', 'The shoutbox is currently offline&#33;', 'You are not allowed to view the shoutbox&#33;', 'You must be a shoutbox moderator to use this feature&#33;', 'You are not allowed to post to the shoutbox&#33;', 'Guests are not allowed to post to the shoutbox&#33;', 'You have been banned from the shoutbox&#33;', 'You can&#39;t delete the shout because it is not yours&#33;', 'You have reached your daily shout limit for the day&#33;', 5, 30, 1, 'new', 'L', 1);

ALTER TABLE ibf_groups ADD g_dshout_limit varchar(200) DEFAULT '0';
ALTER TABLE ibf_groups ADD g_dshouts_today varchar(200) NOT NULL;
ALTER TABLE ibf_members ADD dshouts_alltime int(11) NOT NULL;
ALTER TABLE ibf_members ADD dshout_limit varchar(200) DEFAULT '0';
ALTER TABLE ibf_members ADD dshouts_today varchar(200) NOT NULL;
ALTER TABLE ibf_members ADD last_shout_time int(11) NOT NULL,

UPDATE ibf_cache_store SET cs_key='sbrules' WHERE cs_key='dsbrules' LIMIT 1");